<?php

namespace MGS\FakeOrder\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;
use Magento\Store\Model\StoreManagerInterface;

class GetProductByCatalog implements OptionSourceInterface
{
    protected $categoryCollectionFactory;
    protected $storeManager;

    public function __construct(
        CollectionFactory $categoryCollectionFactory,
        StoreManagerInterface $storeManager
    ) {
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->storeManager = $storeManager;
    }

    /**
     * Retrieve categories as option array
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [];

        // Get store ID
        $storeId = $this->storeManager->getStore()->getId();

        // Get category collection
        $collection = $this->categoryCollectionFactory->create()
            ->addAttributeToSelect('name')
            ->setStoreId($storeId)
            ->addIsActiveFilter();

        // Loop through categories and prepare options
        foreach ($collection as $category) {
            $options[] = [
                'value' => $category->getId(),
                'label' => __($category->getName())
            ];
        }

        return $options;
    }
}
